<?php
  //error_reporting(E_ERROR|E_WARNING);
    /**
    Configuration options:
    zoomType='standard'
    The others admitted option values are 'reverse','drag','innerzoom'.

    zoomWidth=300
    The popup window width showing the zoomed area.

    zoomHeight=300   
    The popup window height showing the zoomed area.

    xOffset=10
    The popup window x offset from the small image. (always positive to move the popup window more on the right if position is "right" or more on the left if position is "left")

    yOffset=0
    The popup window y offset from the small image. (always positive to move the popup window more on the top if position is "top" or more on the bottom if position is "bottom"),

    position='right'
    The popup window position.Admitted values:'right' ,'left' ,'top' ,'bottom'

    preloadImages=true
    if set to true,jqzoom will preload large images.

    preloadText='Loading zoom'
    The text to show while preloading images.

    title=true
    Show a small title over the zoomed window it can be the anchor title and if not specified,it will get the small image title.

    lens=true
    if set to false,the small lens,over the image, won't show.

    imageOpacity=0.4   
    Set the image opacity when the 'zoomType' option is set to 'reverse'.

    showEffect='show'    
    The effect by which showing the popup window.Options available: 'show' ,'fadein'.

    hideEffect='hide'    
    The effect by which hiding the popup window.Options available: 'hide' ,'fadeout'.

    fadeinSpeed='slow'    
    Changes fade in speed,in case the showEffect option is set to 'fadein'.(options: 'fast','slow',number)

    fadeoutSpeed='2000'    
    Changes fade out speed,in case the hideEffect option is set to 'fadeout'.(options: 'fast','slow',number)
    */
    $g=&$GLOBALS;
    $g[HEADER]->addscriptfile(AM_PLUGIN_URL.'/jquery/js/jquery-1.6.1.min.js');
    
    $g[HEADER]->addscriptfile(AM_PLUGIN_URL.'/jquery/js/jquery-ui-1.8.13.custom.min.js');  
    $g[HEADER]->addscriptfile(AM_PLUGIN_URL.'/jqzoom/js/jquery.jqzoom-core.js');

    $g[HEADER]->addstylesheet(AM_PLUGIN_URL.'/jquery/css/ui-lightness/jquery-ui-1.8.13.custom.css');  
    $g[HEADER]->addstylesheet(AM_PLUGIN_URL.'/jqzoom/css/jquery.jqzoom.css'); 
    /**
    * single image zoom
    * 
    * @param mixed $smallImageUrl - small image url
    * @param mixed $bigImageUrl -bigger/larger image url
    * @param mixed $options  - jqzoom configuration option as javascript hash ie. {title:true,zoomType:'innerzoom',zoomWidth:300,zoomHeight:300}
    * @param mixed $title - title of the Image, usually title/name of the item/product/person being displayed
    * @param mixed $class - default 'MYCLASS', it could be any uniq class that is not used in css anywhere in the whole project
    */
    
    function am_jqzoom($smallImageUrl,$bigImageUrl,$options="{zoomType: 'standard'}",$title='',$class='MYCLASS')
    {
        $g=&$GLOBALS;
        $g[HEADER]->addfunction('am_jqzoomImage',"
        \$(document).ready(function(){   
        $('.$class').jqzoom($options); 
        });
        ");
        $title=str_replace('"','&quot;',$title);
        $out="
        <div class='am_jqzoom_mainDv'>
        <a href=\"$bigImageUrl\" class=\"$class\" title=\"$title\">  
        <img src=\"$smallImageUrl\" title=\"$title\">  
        </a>  
        </div>
        ";
        return($out);
    }
     /**
     * provides zoom funciton to a gallery of images
     * 
     * @param mixed $galId - a unique id, usually id from the db on one page it can't be repeated for multiple gallery zoom items
     * @param mixed $galleryArr -2D array of the form []['smallImage']=>'url',[]['bigImage']=>'url',[]['thumbImage']=>'url'
     * @param mixed $options - jqzoom configuration option as javascript hash ie. {title:true,zoomType:'innerzoom',zoomWidth:300,zoomHeight:300}
     * @param mixed $title - title of the Image, usually title/name of the item/product/person being displayed
     * @param mixed $class - default 'MYCLASS', it could be any uniq class that is not used in css anywhere in the whole project
     */
    function am_jqzoomWithThumbs($galId,$galleryArr=array(array('smallimage'=>'','largeimage'=>'')),$options="{zoomType: 'reverse' }",$title='',$class='MYCLASS')
    {
        $g=&$GLOBALS;
        $g[HEADER]->addfunction('am_jqzoomImage',"
        \$(document).ready(function(){
        $('.$class').jqzoom($options); 
        });
        ");
        $title=str_replace('"','&quot;',$title);
        $out="
        <div class='am_jqzoom_mainDv'>
        <a rel='gal$galId' href=\"{$galleryArr[0]['bigImage']}\" class=\"$class\" title=\"$title\">  
        <img src=\"{$galleryArr[0]['smallImage']}\" title=\"$title\">  
        </a>  
        </div>
        <br/>
        <div id='am_jqzoom_gal$galId' class='am_jqzoom_thumbDv'>
        <ul class=\"am_jqzoom_thumblist\">
        ";
        foreach($galleryArr as $k=>$galItem){
            if($k==0){
                $acClass=' class="zoomThumbActive" ';
            }
            else{        
                $acClass='';                        
            }
            $out.="
            <li><a $acClass href='javascript:void(0);' rel=\"{gallery: 'gal$galId', smallimage: '$galItem[smallImage]',largeimage: '$galItem[bigImage]' }\"><img src='$galItem[thumbImage]' /></a></li>           
            ";
        }
        $out.="
        </ul>
        <div style=\"clear:both;width:1px;height:1px;\"></div>
        </div>
        ";
        return($out);
    }
?>
